// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Categorybuttons.pas' rev: 10.00

#ifndef CategorybuttonsHPP
#define CategorybuttonsHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Imglist.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Stdctrls.hpp>	// Pascal unit
#include <Graphutil.hpp>	// Pascal unit
#include <Actnlist.hpp>	// Pascal unit
#include <Menus.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Categorybuttons
{
//-- type declarations -------------------------------------------------------
typedef TMetaClass* TBaseButtonItemClass;

typedef TMetaClass* TButtonItemClass;

typedef TMetaClass* TButtonCategoryClass;

typedef TMetaClass* TButtonCategoriesClass;

typedef TMetaClass* TButtonItemActionLinkClass;

#pragma option push -b-
enum CategoryButtons__1 { bdsSelected, bdsHot, bdsFocused, bdsDown, bdsDragged, bdsInsertLeft, bdsInsertTop, bdsInsertRight, bdsInsertBottom };
#pragma option pop

typedef Set<CategoryButtons__1, bdsSelected, bdsInsertBottom>  TButtonDrawState;

#pragma option push -b-
enum CategoryButtons__2 { boAllowReorder, boAllowCopyingButtons, boFullSize, boGradientFill, boShowCaptions, boVerticalCategoryCaptions, boBoldCaptions, boUsePlusMinus, boCaptionOnlyBorder };
#pragma option pop

typedef Set<CategoryButtons__2, boAllowReorder, boCaptionOnlyBorder>  TCatButtonOptions;

class DELPHICLASS TButtonItem;
typedef void __fastcall (__closure *TCatButtonEvent)(System::TObject* Sender, const TButtonItem* Button);

class DELPHICLASS TButtonCategory;
typedef void __fastcall (__closure *TCatButtonGetHint)(System::TObject* Sender, const TButtonItem* Button, const TButtonCategory* Category, AnsiString &HintStr, bool &Handled);

typedef void __fastcall (__closure *TCatButtonDrawEvent)(System::TObject* Sender, const TButtonItem* Button, Graphics::TCanvas* Canvas, const Types::TRect &Rect, TButtonDrawState State);

typedef void __fastcall (__closure *TCatButtonDrawIconEvent)(System::TObject* Sender, const TButtonItem* Button, Graphics::TCanvas* Canvas, const Types::TRect &Rect, TButtonDrawState State, int &TextOffset);

typedef void __fastcall (__closure *TCatButtonReorderEvent)(System::TObject* Sender, const TButtonItem* Button, const TButtonCategory* SourceCategory, const TButtonCategory* TargetCategory);

typedef void __fastcall (__closure *TCatButtonCopyEvent)(System::TObject* Sender, const TButtonItem* SourceButton, const TButtonItem* CopiedButton);

typedef void __fastcall (__closure *TCategoryReorderEvent)(System::TObject* Sender, const TButtonCategory* SourceCategory, const TButtonCategory* TargetCategory);

typedef void __fastcall (__closure *TCategoryCollapseEvent)(System::TObject* Sender, const TButtonCategory* Category);

#pragma option push -b-
enum TCatButtonFlow { cbfVertical, cbfHorizontal };
#pragma option pop

class DELPHICLASS TCategoryButtons;
class DELPHICLASS TButtonCategories;
class PASCALIMPLEMENTATION TButtonCategories : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
public:
	TButtonCategory* operator[](int Index) { return Items[Index]; }
	
private:
	TCategoryButtons* FButtonGroup;
	int FOriginalID;
	HIDESBASE TButtonCategory* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TButtonCategory* Value);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	virtual void __fastcall Update(Classes::TCollectionItem* Item);
	
public:
	__fastcall TButtonCategories(const TCategoryButtons* ButtonGroup);
	HIDESBASE TButtonCategory* __fastcall Add(void);
	TButtonCategory* __fastcall AddItem(TButtonCategory* Item, int Index);
	virtual void __fastcall BeginUpdate(void);
	HIDESBASE TButtonCategory* __fastcall Insert(int Index);
	int __fastcall IndexOf(const AnsiString Caption);
	__property TButtonCategory* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TCategoryButtons* ButtonGroup = {read=FButtonGroup};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TButtonCategories(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TCategoryButtons : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	TCatButtonFlow FButtonFlow;
	int FCollapsedHeight;
	TButtonItem* FDownButton;
	TButtonItem* FDragButton;
	TButtonCategory* FDragCategory;
	#pragma pack(push,1)
	Types::TPoint FDragStartPos;
	#pragma pack(pop)
	bool FDragStarted;
	Controls::TDragImageList* FDragImageList;
	Graphutil::TGradientDirection FGradientDirection;
	Graphutil::TGradientDirection FBackGradientDirection;
	int FGutterSize;
	int FSideBufferSize;
	TButtonItem* FHotButton;
	Imglist::TChangeLink* FImageChangeLink;
	Imglist::TCustomImageList* FImages;
	TButtonItem* FInsertLeft;
	TButtonItem* FInsertTop;
	TButtonItem* FInsertRight;
	TButtonItem* FInsertBottom;
	bool FIgnoreUpdate;
	int FScrollBarMax;
	int FScrollBarPos;
	int FPageAmount;
	TButtonCategories* FButtonCategories;
	TCatButtonOptions FButtonOptions;
	int FButtonWidth;
	int FButtonHeight;
	Forms::TFormBorderStyle FBorderStyle;
	TButtonItem* FSelectedItem;
	TButtonItem* FFocusedItem;
	bool FMouseInControl;
	Graphics::TColor FBackgroundGradientColor;
	TCatButtonEvent FOnButtonClicked;
	TCatButtonCopyEvent FOnCopyButton;
	TCatButtonEvent FOnSelectedItemChange;
	TCatButtonEvent FOnHotButton;
	TCatButtonGetHint FOnGetHint;
	TCatButtonDrawIconEvent FOnDrawIcon;
	TCatButtonDrawEvent FOnDrawText;
	TCatButtonDrawEvent FOnDrawButton;
	TCatButtonDrawEvent FOnBeforeDrawButton;
	TCatButtonDrawEvent FOnAfterDrawButton;
	TCatButtonReorderEvent FOnReorderButton;
	TCategoryReorderEvent FOnReorderCategory;
	TCategoryCollapseEvent FOnCategoryCollapase;
	Classes::TNotifyEvent FOnClick;
	bool FScrollBarShown;
	Graphics::TColor FHotButtonColor;
	Graphics::TColor FSelectedButtonColor;
	Graphics::TColor FRegularButtonColor;
	void __fastcall AutoScroll(Stdctrls::TScrollCode ScrollCode);
	void __fastcall ImageListChange(System::TObject* Sender);
	int __fastcall CalcButtonsPerRow(void);
	int __fastcall CalcButtonsPerCol(void);
	void __fastcall CalcBufferSizes(void);
	int __fastcall CalcCategoryHeight(const TButtonCategory* Category, const int ButtonsPerRow);
	int __fastcall CalcCategoryWidth(const TButtonCategory* Category, const int ButtonsPerCol);
	void __fastcall DrawCategory(const TButtonCategory* Category, const Graphics::TCanvas* Canvas, int StartingPos);
	void __fastcall GetCategoryBounds(const TButtonCategory* Category, const int StartingPos, Types::TRect &CategoryBounds, Types::TRect &ButtonBounds);
	Types::TRect __fastcall GetChevronBounds(const Types::TRect &CategoryBounds);
	int __fastcall GetIndexOfFirstCategory(void);
	TButtonItem* __fastcall GetNextButtonInGroup(const TButtonItem* StartingButton, bool GoForward);
	TButtonItem* __fastcall GetNextButton(const TButtonItem* StartingButton, bool GoForward);
	int __fastcall GetScrollOffset(void);
	int __fastcall GetScrollBuffer(void);
	void __fastcall ScrollPosChanged(Stdctrls::TScrollCode ScrollCode, int ScrollPos);
	void __fastcall SetOnDrawButton(const TCatButtonDrawEvent Value);
	void __fastcall SetOnDrawIcon(const TCatButtonDrawIconEvent Value);
	void __fastcall SetBorderStyle(const Forms::TBorderStyle Value);
	void __fastcall SetButtonCategories(const TButtonCategories* Value);
	void __fastcall SetButtonHeight(const int Value);
	void __fastcall SetCatButtonOptions(const TCatButtonOptions Value);
	void __fastcall SetButtonWidth(const int Value);
	void __fastcall SetFocusedItem(const TButtonItem* Value);
	void __fastcall SetImages(const Imglist::TCustomImageList* Value);
	void __fastcall SetSelectedItem(const TButtonItem* Value);
	void __fastcall ShowScrollBar(const bool Visible);
	void __fastcall SetHotButtonColor(const Graphics::TColor Value);
	void __fastcall SetRegularButtonColor(const Graphics::TColor Value);
	void __fastcall SetSelectedButtonColor(const Graphics::TColor Value);
	void __fastcall SetButtonFlow(const TCatButtonFlow Value);
	bool __fastcall ShouldScrollDown(/* out */ int &Delay);
	bool __fastcall ShouldScrollUp(/* out */ int &Delay);
	void __fastcall SetGradientDirection(const Graphutil::TGradientDirection Value);
	HIDESBASE MESSAGE void __fastcall CMHintShow(Forms::TCMHintShow &Message);
	HIDESBASE MESSAGE void __fastcall CNKeydown(Messages::TWMKey &Message);
	MESSAGE void __fastcall WMMouseLeave(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMVScroll(Messages::TWMScroll &Message);
	HIDESBASE MESSAGE void __fastcall WMHScroll(Messages::TWMScroll &Message);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Message);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Message);
	void __fastcall SetDragButton(const TButtonItem* Value);
	void __fastcall SetBackgroundGradientColor(const Graphics::TColor Value);
	void __fastcall SetBackGradientDirection(const Graphutil::TGradientDirection Value);
	
protected:
	DYNAMIC void __fastcall BeginAutoDrag(void);
	virtual void __fastcall CreateHandle(void);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	virtual void __fastcall DoBeginDrag(bool Immediate, int Threshold);
	DYNAMIC void __fastcall DoCopyButton(const TButtonItem* Button, const TButtonCategory* TargetCategory, const TButtonItem* TargetButton);
	DYNAMIC void __fastcall DoEndDrag(System::TObject* Target, int X, int Y);
	DYNAMIC void __fastcall DoHotButton(void);
	DYNAMIC void __fastcall DoReorderButton(const TButtonItem* Button, const TButtonCategory* TargetCategory, const TButtonItem* TargetButton);
	DYNAMIC void __fastcall DoReorderCategory(const TButtonCategory* SourceCategory, const TButtonCategory* TargetCategory);
	DYNAMIC void __fastcall DoStartDrag(Controls::TDragObject* &DragObject);
	DYNAMIC void __fastcall DragOver(System::TObject* Source, int X, int Y, Controls::TDragState State, bool &Accept);
	virtual void __fastcall DrawButton(const TButtonItem* Button, Graphics::TCanvas* Canvas, const Types::TRect &Rect, TButtonDrawState State);
	DYNAMIC void __fastcall DoItemClicked(const TButtonItem* Button);
	DYNAMIC void __fastcall DoSelectedItemChanged(const TButtonItem* Button);
	DYNAMIC bool __fastcall DoMouseWheelUp(Classes::TShiftState Shift, const Types::TPoint &MousePos);
	DYNAMIC bool __fastcall DoMouseWheelDown(Classes::TShiftState Shift, const Types::TPoint &MousePos);
	DYNAMIC bool __fastcall GetAllowReorder(void);
	virtual Controls::TDragImageList* __fastcall GetDragImages(void);
	virtual TMetaClass* __fastcall GetButtonCategoriesClass(void);
	virtual TMetaClass* __fastcall GetButtonCategoryClass(void);
	virtual TMetaClass* __fastcall GetButtonItemClass(void);
	int __fastcall GetScrollPos(void);
	void __fastcall SetScrollPos(const int Value);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall Paint(void);
	DYNAMIC void __fastcall Resize(void);
	void __fastcall ScrollRectIntoView(const Types::TRect &Rect);
	HIDESBASE MESSAGE void __fastcall CMFontchanged(Messages::TMessage &Message);
	
public:
	__fastcall virtual TCategoryButtons(Classes::TComponent* AOwner);
	__fastcall virtual ~TCategoryButtons(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property TButtonItem* DragButton = {read=FDragButton, write=SetDragButton};
	__property TButtonCategory* DragCategory = {read=FDragCategory, write=FDragCategory};
	__property Controls::TDragImageList* DragImageList = {read=FDragImageList};
	DYNAMIC void __fastcall DragDrop(System::TObject* Source, int X, int Y);
	void __fastcall GenerateDragImage(void);
	Types::TRect __fastcall GetButtonRect(const TButtonItem* Button);
	Types::TRect __fastcall GetCategoryRect(const TButtonCategory* Category);
	TButtonItem* __fastcall GetButtonAt(int X, int Y, TButtonCategory* Category = (TButtonCategory*)(0x0));
	TButtonCategory* __fastcall GetCategoryAt(int X, int Y);
	void __fastcall RemoveInsertionPoints(void);
	void __fastcall ScrollIntoView(const TButtonItem* Button)/* overload */;
	void __fastcall ScrollIntoView(const TButtonCategory* Category)/* overload */;
	void __fastcall SetInsertionButton(TButtonItem* InsertionButton, TButtonCategory* InsertionCategory);
	void __fastcall GetTargetAt(int X, int Y, TButtonItem* &TargetButton, TButtonCategory* &TargetCategory);
	void __fastcall UpdateButton(const TButtonItem* Button);
	void __fastcall UpdateAllButtons(void);
	__property TButtonItem* SelectedItem = {read=FSelectedItem, write=SetSelectedItem};
	__property TButtonItem* FocusedItem = {read=FFocusedItem, write=SetFocusedItem};
	
__published:
	__property Align  = {default=0};
	__property Anchors  = {default=3};
	__property BevelEdges  = {default=15};
	__property BevelInner  = {index=0, default=2};
	__property BevelOuter  = {index=1, default=1};
	__property BevelKind  = {default=0};
	__property BevelWidth  = {default=1};
	__property BorderWidth  = {default=0};
	__property Forms::TBorderStyle BorderStyle = {read=FBorderStyle, write=SetBorderStyle, default=1};
	__property TCatButtonFlow ButtonFlow = {read=FButtonFlow, write=SetButtonFlow, nodefault};
	__property int ButtonHeight = {read=FButtonHeight, write=SetButtonHeight, default=24};
	__property int ButtonWidth = {read=FButtonWidth, write=SetButtonWidth, default=24};
	__property TCatButtonOptions ButtonOptions = {read=FButtonOptions, write=SetCatButtonOptions, default=56};
	__property DockSite  = {default=0};
	__property DragCursor  = {default=-12};
	__property DragKind  = {default=0};
	__property DragMode  = {default=0};
	__property Enabled  = {default=1};
	__property Font ;
	__property Height  = {default=100};
	__property Imglist::TCustomImageList* Images = {read=FImages, write=SetImages};
	__property Graphics::TColor BackgroundGradientColor = {read=FBackgroundGradientColor, write=SetBackgroundGradientColor, default=536870911};
	__property Graphutil::TGradientDirection BackgroundGradientDirection = {read=FBackGradientDirection, write=SetBackGradientDirection, default=0};
	__property TButtonCategories* Categories = {read=FButtonCategories, write=SetButtonCategories};
	__property Color  = {default=-16777211};
	__property Cursor  = {default=0};
	__property Graphutil::TGradientDirection GradientDirection = {read=FGradientDirection, write=SetGradientDirection, default=0};
	__property Graphics::TColor HotButtonColor = {read=FHotButtonColor, write=SetHotButtonColor, default=15717318};
	__property PopupMenu ;
	__property Graphics::TColor RegularButtonColor = {read=FRegularButtonColor, write=SetRegularButtonColor, nodefault};
	__property Graphics::TColor SelectedButtonColor = {read=FSelectedButtonColor, write=SetSelectedButtonColor, nodefault};
	__property ShowHint ;
	__property TabOrder  = {default=-1};
	__property TabStop  = {default=1};
	__property Width  = {default=100};
	__property Visible  = {default=1};
	__property OnAlignInsertBefore ;
	__property OnAlignPosition ;
	__property TCatButtonDrawEvent OnAfterDrawButton = {read=FOnAfterDrawButton, write=FOnAfterDrawButton};
	__property TCatButtonDrawEvent OnBeforeDrawButton = {read=FOnBeforeDrawButton, write=FOnBeforeDrawButton};
	__property TCatButtonEvent OnButtonClicked = {read=FOnButtonClicked, write=FOnButtonClicked};
	__property TCategoryCollapseEvent OnCategoryCollapase = {read=FOnCategoryCollapase, write=FOnCategoryCollapase};
	__property Classes::TNotifyEvent OnClick = {read=FOnClick, write=FOnClick};
	__property OnContextPopup ;
	__property TCatButtonCopyEvent OnCopyButton = {read=FOnCopyButton, write=FOnCopyButton};
	__property OnDockDrop ;
	__property OnDockOver ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property TCatButtonDrawEvent OnDrawButton = {read=FOnDrawButton, write=SetOnDrawButton};
	__property TCatButtonDrawIconEvent OnDrawIcon = {read=FOnDrawIcon, write=SetOnDrawIcon};
	__property TCatButtonDrawEvent OnDrawText = {read=FOnDrawText, write=FOnDrawText};
	__property OnEndDock ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property TCatButtonGetHint OnGetHint = {read=FOnGetHint, write=FOnGetHint};
	__property TCatButtonEvent OnHotButton = {read=FOnHotButton, write=FOnHotButton};
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property TCatButtonReorderEvent OnReorderButton = {read=FOnReorderButton, write=FOnReorderButton};
	__property TCategoryReorderEvent OnReorderCategory = {read=FOnReorderCategory, write=FOnReorderCategory};
	__property OnMouseActivate ;
	__property OnMouseDown ;
	__property OnMouseEnter ;
	__property OnMouseLeave ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnMouseWheel ;
	__property OnMouseWheelDown ;
	__property OnMouseWheelUp ;
	__property TCatButtonEvent OnSelectedItemChange = {read=FOnSelectedItemChange, write=FOnSelectedItemChange};
	__property OnStartDock ;
	__property OnStartDrag ;
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TCategoryButtons(HWND ParentWindow) : Controls::TCustomControl(ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TBaseButtonItem;
class DELPHICLASS TButtonItemActionLink;
class PASCALIMPLEMENTATION TButtonItemActionLink : public Actnlist::TActionLink 
{
	typedef Actnlist::TActionLink inherited;
	
protected:
	TBaseButtonItem* FClient;
	virtual void __fastcall AssignClient(System::TObject* AClient);
	virtual bool __fastcall IsCaptionLinked(void);
	virtual bool __fastcall IsHintLinked(void);
	virtual bool __fastcall IsImageIndexLinked(void);
	virtual bool __fastcall IsOnExecuteLinked(void);
	virtual void __fastcall SetCaption(const AnsiString Value);
	virtual void __fastcall SetHint(const AnsiString Value);
	virtual void __fastcall SetImageIndex(int Value);
	virtual void __fastcall SetOnExecute(Classes::TNotifyEvent Value);
	
public:
	virtual bool __fastcall DoShowHint(AnsiString &HintStr);
public:
	#pragma option push -w-inl
	/* TBasicActionLink.Create */ inline __fastcall virtual TButtonItemActionLink(System::TObject* AClient) : Actnlist::TActionLink(AClient) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TBasicActionLink.Destroy */ inline __fastcall virtual ~TButtonItemActionLink(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TBaseButtonItem : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	TButtonItemActionLink* FActionLink;
	Imglist::TImageIndex FImageIndex;
	AnsiString FCaption;
	void *FData;
	AnsiString FHint;
	Classes::TNotifyEvent FOnClick;
	void __fastcall SetAction(const Classes::TBasicAction* Value);
	void __fastcall SetCaption(const AnsiString Value);
	void __fastcall SetImageIndex(const Imglist::TImageIndex Value);
	Classes::TBasicAction* __fastcall GetAction(void);
	void __fastcall DoActionChange(System::TObject* Sender);
	bool __fastcall IsCaptionStored(void);
	bool __fastcall IsHintStored(void);
	bool __fastcall IsImageIndexStored(void);
	bool __fastcall IsOnClickStored(void);
	
protected:
	virtual void __fastcall ActionChange(System::TObject* Sender, bool CheckDefaults);
	virtual Classes::TComponent* __fastcall GetNotifyTarget(void) = 0 ;
	virtual AnsiString __fastcall GetDisplayName();
	virtual TMetaClass* __fastcall GetActionLinkClass(void);
	__property TButtonItemActionLink* ActionLink = {read=FActionLink, write=FActionLink};
	
public:
	__fastcall virtual TBaseButtonItem(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property void * Data = {read=FData, write=FData};
	virtual void __fastcall ScrollIntoView(void) = 0 ;
	
__published:
	__property Classes::TBasicAction* Action = {read=GetAction, write=SetAction};
	__property AnsiString Caption = {read=FCaption, write=SetCaption, stored=IsCaptionStored};
	__property AnsiString Hint = {read=FHint, write=FHint, stored=IsHintStored};
	__property Imglist::TImageIndex ImageIndex = {read=FImageIndex, write=SetImageIndex, stored=IsImageIndexStored, nodefault};
	__property Classes::TNotifyEvent OnClick = {read=FOnClick, write=FOnClick, stored=IsOnClickStored};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TBaseButtonItem(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TButtonItem : public TBaseButtonItem 
{
	typedef TBaseButtonItem inherited;
	
private:
	System::_di_IInterface FInterfaceData;
	TCategoryButtons* __fastcall GetButtonGroup(void);
	TButtonCategory* __fastcall GetCategory(void);
	
protected:
	virtual Classes::TComponent* __fastcall GetNotifyTarget(void);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property System::_di_IInterface InterfaceData = {read=FInterfaceData, write=FInterfaceData};
	virtual void __fastcall ScrollIntoView(void);
	__property TButtonCategory* Category = {read=GetCategory};
	
__published:
	__property TCategoryButtons* ButtonGroup = {read=GetButtonGroup};
public:
	#pragma option push -w-inl
	/* TBaseButtonItem.Create */ inline __fastcall virtual TButtonItem(Classes::TCollection* Collection) : TBaseButtonItem(Collection) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TButtonItem(void) { }
	#pragma option pop
	
};


class DELPHICLASS TButtonCollection;
class PASCALIMPLEMENTATION TButtonCollection : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
public:
	TButtonItem* operator[](int Index) { return Items[Index]; }
	
private:
	TButtonCategory* FCategory;
	HIDESBASE TButtonItem* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TButtonItem* Value);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	virtual void __fastcall Update(Classes::TCollectionItem* Item);
	virtual void __fastcall Notify(Classes::TCollectionItem* Item, Classes::TCollectionNotification Action);
	
public:
	__fastcall TButtonCollection(const TButtonCategory* ACategory);
	HIDESBASE TButtonItem* __fastcall Add(void);
	TButtonItem* __fastcall AddItem(TButtonItem* Item, int Index);
	HIDESBASE TButtonItem* __fastcall Insert(int Index);
	__property TButtonItem* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TButtonCategory* Category = {read=FCategory};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TButtonCollection(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TButtonCategory : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	AnsiString FCaption;
	bool FCollapsed;
	Graphics::TColor FColor;
	Graphics::TColor FGradientColor;
	Graphics::TColor FTextColor;
	TButtonCollection* FItems;
	int FStart;
	int FEnd;
	void *FData;
	System::_di_IInterface FInterfaceData;
	TButtonCategories* __fastcall GetCategories(void);
	void __fastcall SetItems(const TButtonCollection* Value);
	void __fastcall SetCollapsed(const bool Value);
	void __fastcall SetCaption(const AnsiString Value);
	void __fastcall SetColor(const Graphics::TColor Value);
	void __fastcall SetGradientColor(const Graphics::TColor Value);
	void __fastcall SetTextColor(const Graphics::TColor Value);
	
protected:
	virtual void __fastcall SetIndex(int Value);
	
public:
	__fastcall virtual TButtonCategory(Classes::TCollection* Collection);
	__fastcall virtual ~TButtonCategory(void);
	void __fastcall ScrollIntoView(void);
	int __fastcall IndexOf(const AnsiString Caption);
	__property TButtonCategories* Categories = {read=GetCategories};
	__property void * Data = {read=FData, write=FData};
	__property System::_di_IInterface InterfaceData = {read=FInterfaceData, write=FInterfaceData};
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	
__published:
	__property AnsiString Caption = {read=FCaption, write=SetCaption};
	__property Graphics::TColor Color = {read=FColor, write=SetColor, nodefault};
	__property bool Collapsed = {read=FCollapsed, write=SetCollapsed, nodefault};
	__property Graphics::TColor GradientColor = {read=FGradientColor, write=SetGradientColor, default=536870911};
	__property TButtonCollection* Items = {read=FItems, write=SetItems};
	__property Graphics::TColor TextColor = {read=FTextColor, write=SetTextColor, default=-16777208};
};


//-- var, const, procedure ---------------------------------------------------
static const Controls::TCursor crDragCopy = -23;

}	/* namespace Categorybuttons */
using namespace Categorybuttons;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Categorybuttons
